/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: segment.h,v 1.6 2005/09/22 18:32:18 sfs Exp $ */
/* Contains segment-specific functions, and also functions to 
   handle a list of segments (these really belong in node.h). */

#ifndef SEGMENT_H
#define SEGMENT_H

typedef struct segment {
  double begin;
  double end;
  struct segment *next;
} Segment;

Segment* segment_union (Segment*, Segment*);
Segment* segment_intersect (Segment *, Segment*);
void print_segs (Segment *);
int seg_contains (Segment * seg, double loc);
Segment * segment_inverse (Segment *);
Segment * segment_new (double begin, double end);

Segment * segment_add (Segment *, double, double);


#endif /* SEGMENT_H */
