/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: segment.c,v 1.6 2005/09/22 18:32:18 sfs Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include "segment.h"

void segment_delete (Segment* segptr)
{}

Segment *
segment_new (double begin, double end) 
{
  Segment *segptr;
	
  if ((segptr = (Segment *) malloc (sizeof (*segptr))) == NULL) {
    printf("malloc, segment_new\n");
    exit(0);
  }
	
  segptr->begin = begin;
  segptr->end = end;
  segptr->next = NULL;

  return segptr;
}

Segment *
segment_inverse (Segment *segptr) 
{
  Segment *newseg, *newseg2;
  Segment *oldseg, *headseg;
  int setend = 1;

  if (segptr == NULL) 
    return segment_new(0,1);

  headseg = (Segment *) malloc(sizeof (* headseg));
  newseg = headseg;

  oldseg = segptr;

  if (oldseg->begin > 0)
    newseg->begin = 0;
  else {
    newseg->begin = oldseg->end;
    oldseg = oldseg->next;
  }

  while (oldseg != NULL) {
    newseg->end = oldseg->begin;
    if (oldseg->end != 1) {
			
      newseg2 = (Segment *) malloc(sizeof (* newseg));
      newseg->next = newseg2;
      newseg = newseg2;
      newseg->begin = oldseg->end;
      oldseg = oldseg->next;
    }
    else {
      setend = 0;
      oldseg = oldseg->next;
    }
  }
       
  if (setend)
    newseg->end = 1;


  newseg->next = NULL;
  return headseg;
}

Segment* 
segment_union (Segment* segptr1, Segment* segptr2) 
{
  Segment *activesegptr, *nextsegptr, *tempptr;
  double begin, end;
  Segment *newptr;
	
  newptr = NULL;
	
  if (segptr1 != NULL && segptr2 != NULL) {
		
    if (segptr1->begin < segptr2->begin) {
      begin = segptr1->begin;
      end = segptr1->end;
      nextsegptr = segptr1->next;
      activesegptr = segptr2;
    }
    else { 
      begin = segptr2->begin;
      end = segptr2->end;
      nextsegptr = segptr2->next;
      activesegptr = segptr1;
    }
		
    if (nextsegptr != NULL && (activesegptr->begin > nextsegptr->begin)) {
      tempptr = nextsegptr;
      nextsegptr = activesegptr;
      activesegptr = tempptr;
    }
  }
  else {
    printf("segment_union: you did something wrong - null segment.\n");
    exit(0);
    /*    if one or the other is null 
	  this has got to be impossible. */
  }
	
  /* updating begin/end using activesegptr */
  if (activesegptr->begin > end) {
    newptr = segment_add(newptr, begin, end);
    begin = activesegptr->begin;
    end = activesegptr->end;    
  } 
  else if (activesegptr->end > end) {
    end = activesegptr->end;
  }
	
	
  /* choosing between activesegptr->next and nextsegptr */
  while (activesegptr->next != NULL && nextsegptr != NULL) {
		
    if (activesegptr->next->begin > nextsegptr->begin) {
      tempptr = nextsegptr;
      nextsegptr = activesegptr->next;
      activesegptr = tempptr;
    }
    else {
      activesegptr = activesegptr->next;
    }
		
    /* if next possible segment is disjoint, add this segment, and startover. */
    if (activesegptr->begin > end) {
      newptr = segment_add(newptr, begin, end);
      begin = activesegptr->begin;
      end = activesegptr->end;    
    } 
    else if (activesegptr->end > end) {
      end = activesegptr->end;
    }
  }
	
  /* when we reach this point, either activesegptr->next is null or nextsegptr is null. */
	
  if (nextsegptr != NULL) {
    activesegptr = nextsegptr;
		
  }
  
  /* end */
  else {
    activesegptr = activesegptr->next;
  }  
  
  while (activesegptr != NULL) {
    /* first check if activesegptr->next overlaps the current begin/end
       then copy all of activesegptr to new segment */
    
    if (activesegptr->begin > end) {
      newptr = 
	segment_add(newptr, begin, end);
      begin = activesegptr->begin;
      end = activesegptr->end;
    }
	  
    else if (activesegptr->end > end) {
      end = activesegptr->end;
    }

    activesegptr = activesegptr->next;
  
    /*end */
  }
  newptr = segment_add(newptr, begin, end);

  
  return newptr;

}


Segment * 
segment_intersect (Segment *segptr1, Segment* segptr2) {
  Segment *newsegptr = NULL;
  double begin, end;

  Segment *firstseg, *secondseg, *tempseg;

  if (segptr1 == NULL || segptr2 == NULL) {
    printf("stop! you did something wrong. null seg in seg intersect\n");
  }

  if (segptr1->begin < segptr2->begin) {
    firstseg = segptr1;
    secondseg = segptr2;
  }
  else {
    firstseg = segptr2;
    secondseg = segptr1;
  }

  while (firstseg != NULL && secondseg != NULL) {
    /* which is first, first or 2nd? */
    if (firstseg->begin > secondseg->begin) {
      tempseg = firstseg;
      firstseg = secondseg;
      secondseg = tempseg;
    }
		

    /* if they overlap: */
    if (firstseg->end > secondseg->begin) {
      begin = secondseg->begin;
			
      /* if second is wholly contained in first */
      if (firstseg->end > secondseg->end) {
	end = secondseg->end;
	secondseg = secondseg->next;
      }
			
      else {
	end = firstseg->end;
	firstseg = firstseg->next;
      }
			
      newsegptr = segment_add(newsegptr, begin, end);
    }
    else {
      firstseg = firstseg->next;
    }
  }

  return newsegptr;
}




/* needs to add new segments in order. 
   assume there will be no overlaps added. */

Segment* 
segment_add (Segment *ptr, double begin, double end) 
{
  Segment *newptr;
	
	
  if (ptr == NULL) {
    if ((newptr = (Segment *) malloc (sizeof (*newptr))) == NULL) { 
      printf("malloc, segment_add\n");
      exit(0);
    }
		
    newptr->begin = begin;
    newptr->end = end;
    newptr->next = ptr;
    return newptr;
  }
	
  else if (ptr->begin > begin) {
    if ((newptr = (Segment *) malloc (sizeof (*newptr))) == NULL) { 
      printf("malloc, segment_add\n");
      exit(0);
    }
		
    newptr->begin = begin;
    newptr->end = end;
    newptr->next = ptr;
    return newptr;
  }
	
  else {
    ptr->next = segment_add(ptr->next, begin, end);
    return ptr;
  }
}


void 
print_segs (Segment *segptr) 
{
  if (segptr != NULL) {
    printf("%f:%f ", segptr->begin, segptr->end);
    print_segs (segptr->next);
  }
}

int 
seg_contains (Segment * seg, double loc) 
{
  while (seg != NULL) {
    if (loc >= seg->begin) {
      if (loc <= seg->end) {return 1;}
      seg = seg->next;
    }
    else { 
      return 0;
    }
  }
  return 0;
}
