/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: pop.h,v 1.5 2005/09/22 18:32:18 sfs Exp $ */

#ifndef POP_H 
#define POP_H

/* 
 * Needs "nodelist.h" and "defs.h" 
 */

typedef struct Pop {
	popid name;
	NodeList members;
	int popsize;
	char label[30];
} Pop;

Pop * pop_new (popid  popname , int  popsize , 
	       char *  label );
void pop_remove_node ( Pop *, Node *);
void pop_add_node ( Pop *, Node *);
int pop_get_num_nodes ( Pop *);
void pop_print_nodes ( Pop *);
Node * pop_get_node (int, NodeList *);
void pop_set_size (Pop * , int  size  );
popid pop_get_name(Pop *);


#endif /* POP_H */
