/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: pop.c,v 1.6 2005/09/22 18:32:18 sfs Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "defs.h"
#include "segment.h"
#include "node.h"
#include "nodelist.h"
#include "pop.h"

Pop * 
pop_new (popid name, int popsize, char* label) 
{
  Pop *popptr;
	
  if ((popptr = (Pop *) malloc (sizeof (*popptr))) == NULL) {
    printf("malloc, pop_new\n");
    exit(0);
  }
  popptr->name = name;
  nodelist_initialize(&(popptr->members));
  popptr->popsize = popsize;
  strcpy( popptr->label, label);
	
  return popptr;
}

void 
pop_remove_node ( Pop *popptr, struct node *nodeptr) 
{
  if (nodelist_remove(&(popptr->members), nodeptr) == 1) {}
  else if (POP_DEBUG) printf("fail to remove\n");
}

void 
pop_add_node ( Pop *popptr, struct node *nodeptr) 
{
  nodelist_add(&(popptr->members), nodeptr);
}

void 
pop_print_nodes ( Pop *popptr ) 
{
  nodelist_printnodenames (&(popptr->members));
  printf("\n");
}

void
pop_set_size (Pop *popptr, int size) 
{
  popptr->popsize = size;
}

int 
pop_get_num_nodes ( Pop *popptr) 
{
  return popptr->members.nummembers;
}

popid
pop_get_name(Pop *popptr) {
  return popptr->name;
}

/* returns the node at a specified index */
Node * 
pop_get_node (int index1, NodeList * nodelistptr) 
{
  /* count from the end of list to emuulate behavior of 
     linked list that I'm replacing.  sfs */
  /*  if (index1 < 0 || index1 >=nodelistptr->nummembers) {
    fprintf(stderr, "Bad index in pop_get_node\n");
    exit(0);
  }
  */
  index1 = nodelistptr->nummembers - index1 - 1;
  return nodelistptr->nodes[index1];
}

