/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "defs.h"
#include "haplos.h"
#include "mutlist.h"

static int sortcomp(const void* vp, const void* vq);
static double *sortVals;

static int inf_sites = 0;

void out_set_infinite_sites(int infinite) {
  inf_sites = infinite;
}


void print_haps(char *filebase, int length, Mutlist *mutlist, Haplos *haps) {

  int ipop, ichr, im, nchr, i, jm;
  int *chrcount, *mutsort, *mutcount=NULL, *usemut=NULL;
  char filename[256], idstr[16];
  FILE *outf;
  char* ahap;
  double freq;


  chrcount = calloc(haps->npop, sizeof(int));
  mutsort = malloc(mutlist->nmut * sizeof(int));
  ahap = malloc(mutlist->nmut * sizeof(char));
  usemut = malloc(mutlist->nmut * sizeof(int));
  assert(chrcount != NULL && mutsort != NULL && ahap != NULL && usemut != NULL);

  for (ichr = 0; ichr < haps->nchrom; ichr++) {
    chrcount[haps->which_pop_ind[ichr]]++;
  }

  for (im = 0; im < mutlist->nmut; im++) {
    mutsort[im] = im;
    usemut[im] = 1;
  }
  sortVals = mutlist->pos;
  qsort(mutsort, mutlist->nmut, sizeof(int), sortcomp);
  
  if (!inf_sites) {
    for (im = 0; im < mutlist->nmut; im++) {
      jm = im + 1;
      while (jm < mutlist->nmut && (int) (length * mutlist->pos[mutsort[im]]) == (int) (length * mutlist->pos[mutsort[jm]])) {
	usemut[mutsort[jm]] = 0;
	jm++;
      }
    }
  }

  for (ipop = 0; ipop < haps->npop; ipop++) {
    if (chrcount[ipop] > 0) {
      strcpy(filename, filebase);
      strcat(filename, ".hap-");
      sprintf(idstr, "%d", haps->popid[ipop]);
      strcat(filename, idstr);
      outf = fopen(filename, "w");
      if (outf == NULL) {fprintf(stderr, "Could not open %s\n", filename);}
      free(mutcount);
      mutcount = calloc(mutlist->nmut, sizeof(int));


      nchr = 0;
      for (ichr = 0; ichr < haps->nchrom; ichr++) {
	if (haps->which_pop_ind[ichr] != ipop) {continue;}
	fprintf(outf, "%d\t%d\t", ichr, haps->popid[ipop]);
	for (im = 0; im < mutlist->nmut; im++) {ahap[im] = 2;}
	for (i = 0; i < haps->nmut[ichr]; i++) {
	  ahap[haps->mutindex[ichr][i]] = 1;
	  mutcount[haps->mutindex[ichr][i]]++;
	}
	for (im = 0; im < mutlist->nmut; im++) {
	  if (usemut[mutsort[im]]) {
	    fprintf(outf, "%d ", ahap[mutsort[im]]);
	  }
	}
	fprintf(outf, "\n");
	nchr++;
      }
      
      fclose(outf);
      

      strcpy(filename, filebase);
      strcat(filename, ".pos-");
      sprintf(idstr, "%d", haps->popid[ipop]);
      strcat(filename, idstr);
      outf = fopen(filename, "w");
      if (outf == NULL) {fprintf(stderr, "Could not open %s\n", filename);}
      fprintf(outf, "SNP     CHROM   CHROM_POS       ALLELE1 FREQ1   ALLELE2 FREQ2\n");
      for (im = 0; im < mutlist->nmut; im++) {
	freq = (double) mutcount[mutsort[im]] / chrcount[ipop];
	if (usemut[mutsort[im]]) {
	  if (inf_sites) {
	    fprintf(outf, "%d\t1\t%.4f\t1\t%.4f\t2\t%.4f\n", im+1, length * mutlist->pos[mutsort[im]], 
		    freq, 1 - freq);
	  }
	  else {
	    if (im > 0 && (int) (length * mutlist->pos[mutsort[im]]) == (int) (length * mutlist->pos[mutsort[im-1]])) {
	      fprintf(stderr, "double hit: %f & %f\n", length * mutlist->pos[mutsort[im]], length * mutlist->pos[mutsort[im-1]]);
	    }
	    fprintf(outf, "%d\t1\t%d\t1\t%.4f\t2\t%.4f\n", im+1, (int) (length * mutlist->pos[mutsort[im]]), 
		    freq, 1 - freq);
	  }
	}
      }
      fclose(outf);

    }
  }

}

int sortcomp(const void* vp, const void* vq) {
  int *p = (int*) vp;
  int *q = (int*) vq;
  return ((sortVals[(*p)] == sortVals[(*q)]) ? 0 : (sortVals[(*p)] < sortVals[(*q)]) ? -1 : 1);
}
