/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: nodelist.h,v 1.3 2005/09/22 18:32:18 sfs Exp $ */

#ifndef NODELIST_H
#define NODELIST_H
#define NODELIST_INITSIZE 200

/*
 * Needs <stdio.h> <stdlib.h> and "node.h"
 */

typedef struct nodelist {
  Node **nodes;   /* array of ptrs to Node*/
  int nummembers;
  int sizenow;  /* memory management */
} NodeList;

int nodelist_add(NodeList *, Node *);
int nodelist_remove(NodeList *, Node *);
void nodelist_printnodenames (NodeList *);
void nodelist_initialize(NodeList *);

#endif /* NODELIST_H */

