/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: nodelist.c,v 1.3 2005/09/22 18:32:18 sfs Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include "defs.h"
#include "segment.h"
#include "node.h"
#include "nodelist.h"

int
nodelist_add(NodeList *nlptr, Node *nodeptr) {
  if (nlptr->nummembers >= nlptr->sizenow-1) {
    nlptr->sizenow *= 2;
    nlptr->nodes = realloc(nlptr->nodes, nlptr->sizenow * sizeof(Node*));
  }
  nlptr->nodes[nlptr->nummembers] = nodeptr;
  nlptr->nummembers++;
  return 1;
}

/* removes a node according to its name */
int 
nodelist_remove(NodeList *nlptr, struct node *nodeptr) 
{
  int i, j;
  for (i = 0; i < nlptr->nummembers; i++) {
    if (nlptr->nodes[i]->name == nodeptr->name) {
      /* shift the remaining nodes */
      for (j = i; j < nlptr->nummembers-1; j++) {
	nlptr->nodes[j] = nlptr->nodes[j+1];
      }
      nlptr->nummembers--;
      return 1;
    }
  }
  return 0;
}

void 
nodelist_printnodenames(NodeList *nlptr) 
{
  int i;
  for (i = 0; i < nlptr->nummembers; i++) {
    printf ("%d ", nlptr->nodes[i]->name);
  }
}

void 
nodelist_initialize(NodeList *nodelistptr) {
  nodelistptr->nummembers = 0;
  nodelistptr->sizenow = NODELIST_INITSIZE;
  nodelistptr->nodes = malloc(NODELIST_INITSIZE * sizeof(Node*));
}
