/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: node.h,v 1.5 2005/09/22 18:32:18 sfs Exp $ */

#ifndef NODE_H
#define NODE_H

/* 
 * Needs "defs.h" and "segment.h".
 */

typedef struct node {
  nodeid name;
  popid pop;
  Segment *segs;
  genid gen;
  struct node *descendent[2];
} Node;

Node * make_new_node (double, double, genid  gen , int);
Node * make_empty_node (genid  gen , int, Node *);
Node * node_coalesce (Node *, Node *, genid  gen);
/* returns the number of recombinant ancestors */
int node_recombine( Node*, Node**, Node**, genid  gen , double);
int
node_gc (Node *  node , Node **  newnode1 , Node **  newnode2 , 
	 genid  gen , double  loc , double  locend);
int node_break_off_seg (Node *  node  , Node **  newnode1 , 
			Node **  newnode2 , double  begin , 
			double  end);
void print_node (Node *);

#endif /* NODE_H */
