/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
#ifndef HAPLO_H
#define HAPLO_H

/* Must store pop information since it is lost by output time */

typedef struct Haplos {
  int npop;
  popid *popid;
  int nchrom;
  int *which_pop_ind;
  int **mutindex;
  int *nmut;
  int *mut_array_size;
} Haplos;

void hap_assign_chroms(Haplos *);


#endif
