/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "defs.h"
#include "segment.h"
#include "node.h"
#include "nodelist.h"
#include "pop.h"
#include "demography.h"
#include "haplos.h"

void hap_assign_chroms(Haplos *haps) {
  int npop, ipop, running=0, ichrom, nchr, chrom_index;
  const int init_size = 100;
  Pop* apop;
  popid popname;
  
  npop = dg_get_num_pops();
  haps->npop = npop;
  haps->popid = malloc(npop * sizeof(popid));
  assert(haps->popid != NULL);
  for (ipop = 0; ipop < npop; ipop++) {
    running += dg_get_num_nodes_in_pop_by_index(ipop);
    haps->popid[ipop] = dg_get_pop_name_by_index(ipop);
  }
  
  haps->nchrom = running;
  haps->which_pop_ind = malloc(running * sizeof(int));
  haps->mut_array_size = malloc(running * sizeof(int));
  haps->nmut = calloc(running, sizeof(int));
  haps->mutindex = malloc(running * sizeof(int*));
  assert(haps->which_pop_ind != NULL);
  assert(haps->mut_array_size != NULL);
  assert(haps->mutindex != NULL);
  assert(haps->nmut != NULL);
  
  running = 0;
  for (ipop = 0; ipop < npop; ipop++) {
    apop = dg_get_pop_by_index(ipop);
    nchr = pop_get_num_nodes(apop);
    popname = pop_get_name(apop);
    for (ichrom = 0; ichrom < nchr; ichrom++) {
      chrom_index = pop_get_node(ichrom, &(apop->members))->name;
      haps->mut_array_size[chrom_index] = init_size;
      haps->mutindex[chrom_index] = malloc(init_size * sizeof(int));
      assert(haps->mutindex[chrom_index] != NULL);
      haps->which_pop_ind[chrom_index] = ipop;
    }
    running += nchr;
  }

}
