/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: geneconversion.c,v 1.7 2005/09/22 18:32:17 sfs Exp $ */
#include <stdlib.h>
#include <stdio.h>
#include "defs.h"
#include "../cosi_rand/random.h"
#include "segment.h"
#include "node.h"
#include "nodelist.h"
#include "pop.h"
#include "demography.h"
#include "recomb.h"

double gc_geneconversionrate = 0;
/* gc_gclength is the length of the gene conversion segment. */
int gc_gclength = 500; /* in bp */
double gc_gcrate = 0;
double gc_lastgcrate = 0;
int gc_length;

void 
gc_set_rate (double gcr) 
{
	gc_geneconversionrate = gcr;

}

void gc_set_length (int l) {
	gc_length = l;
	gc_gcrate = gc_geneconversionrate * (gc_length + gc_gclength);

	if (DEBUG)
		printf("rate: %f length: %d\n", gc_geneconversionrate, gc_length);

}

double gc_get_r(void) {
  return gc_gcrate;
}

double gc_get_rate (void) {
	int numpops = dg_get_num_pops();
	int i;
	double rate = 0;
	int numnodes;

	if (gc_gcrate == 0) return 0;

	for (i = 0; i < numpops; i++) {
		numnodes = dg_get_num_nodes_in_pop_by_index (i);
		rate += ( numnodes * gc_gcrate);
	}

	gc_lastgcrate = rate;
	return rate;  
}

int gc_pick_popindex(void) {
  /* figure out which pop to recombine */
  int popindex = 0;
  double randcounter = random_double() * gc_lastgcrate;
  int numpops = dg_get_num_pops();
  int numnodes, i;
  double rate = 0;

  /* weigh pops by numnodes. */
  if (numpops > 1) {
    for (i = 0; i < numpops && rate < randcounter; i++) {
      numnodes = dg_get_num_nodes_in_pop_by_index(i);
      rate += (numnodes * gc_gcrate);
      /* don't need this multiplication */
    }
    popindex = i - 1;
  }
  return popindex;
}

Node** gc_execute (double gen, int popindex, double *location1, double *location2) {
  double loc, loc2;
  double temp;
  double temp1;
  /* choosing location.. */
  temp1 = random_double();
  temp = (double) (temp1 * (gc_gcrate));
  
  loc = (double)((int) (temp / gc_gcrate * 
			(gc_length + gc_gclength) - gc_gclength)) / gc_length;
  loc2 = (double)((int) (temp / gc_gcrate * (gc_length + gc_gclength))) / gc_length;
  
  if (loc2 > gc_length) loc2 = gc_length;
  *location1 = loc;
  *location2 = loc2;
  
  return dg_gc_by_index (popindex, gen, loc, loc2);
}

