/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: demography.h,v 1.6 2006/01/18 19:26:25 sfs Exp $ */

#ifndef DEMOGRAPHY_H
#define DEMOGRAPHY_H

/* Needs <stdio.h> and "defs.h" */

/* definitions for dg_log */
#define ADD_NODE 1
#define COALESCE 2
#define CREATE_POP 3
#define RECOMBINE 4
#define DONE 5
#define MOVE 7
#define CHANGE_SIZE 8
#define MIG_RATE 9
#define HISTORICAL 10
#define GENE_CONVERSION 12

struct sitelist 
{
  double site;
  int nnode;
  struct sitelist *next;
};


void dg_initialize(void);
void dg_init_recomb(void);


/* Recomb site list */
struct sitelist * dg_recombsites(void);

/* POP FUNCTIONS */

void dg_create_pop (popid popname, char * label, 
		    genid gen);
void dg_populate_by_name (popid popname, 
			  int members,  genid gen);
int dg_get_num_pops (void);
char* dg_get_pop_label_by_name (popid popname);
popid dg_get_pop_name_by_label (char* label);
popid dg_get_pop_name_by_index (int popindex);
int dg_get_pop_index_by_name (popid popname);
Pop * dg_get_pop_by_index (int index1);
Pop * dg_get_pop_by_name(popid popname);

/* POP_SIZE FUNCTIONS */
int dg_get_pop_size_by_index (int popindex);
int dg_set_pop_size_by_name (genid gen, popid popname, 
			     int newsize);

/* ENDING POPS */
void dg_end_pop_by_name (popid popname);


/* POISSON EVENTS */

/* coalesce */
void dg_coalesce_by_index (int popindex, genid);
void dg_coalesce_by_name (popid popname, genid);

/* recombine */  /* array[0]=old node  [1,2]=new nodes.  Caller must free ptr.  NULL => no visible recomb. */
Node** dg_recombine_by_index (int, genid, double);

/* migrate */
void dg_migrate_one_chrom (popid frompop, popid topop, genid);

/* geneconversion */
Node** dg_gc_by_index (int popindex,  genid gen, 
		     double loc, double locend);

/* FOR HISTORICAL EVENTS */

void dg_move_nodes_by_name (int, int, double percent, genid gen);

/* NODE FUNCTIONS */

Node * dg_get_head_node (rsitenum regionnum);
int dg_get_num_nodes (void);
int dg_get_num_nodes_in_pop_by_index (int);
int dg_get_num_nodes_in_pop_by_name (popid popname);

/* DONE? */
int dg_done_coalescent(void);


/* logging function */
/* since logging is slow, we have the option to turn it
   off. */
void dg_log (int type, genid gen, ...);
void dg_logging_on (void);
void dg_logging_off (void);
void dg_set_logfile (FILE *);

/* MUTATION - simulator.c */

double dg_reg_center (int regionnum);
double dg_reg_begin (int regionnum);
genid dg_total_tree_time (rsitenum rindex);
rsitenum dg_get_num_regs (void);
double dg_get_reg_length (rsitenum rindex);

#endif /* DEMOGRAPHY_H */

