/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: coalescent.c,v 1.9 2006/01/18 19:26:25 sfs Exp $ */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "defs.h"
#include "segment.h"
#include "node.h"
#include "nodelist.h"
#include "pop.h"
#include "demography.h"
#include "mutlist.h"
#include "haplos.h"
#include "simulator.h"
#include "output.h"
#include "file.h"

void printusage(void);

int 
main(int argc, char *argv[]) {

  char    *prog = argv[0],
    * paramfile = NULL, 
    * segfile = NULL, 
    * logfile = NULL,
    * outfilebase = NULL,
    c;
  int     segfileset = 0, 
    logfileset = 0,
    outfileset = 0,
    paramfileset = 0,
    usage = 0,
    verbose = 0, 
    length;
  FILE    * segfp, 
    * logfp;
  Haplos haps;
  Mutlist muts;
  
  while (--argc > 0 && (*++argv)[0] == '-') {
    c = *++argv[0];
    switch (c) {
      
    case 'l':      /* set logfile */
      logfile = (*++argv);
      logfileset = 1;
      if (DEBUG)
	printf("logfile: %s\n", logfile);
      argc--;
      break;
      
    case 'p':      /* set param file */
      paramfile = (*++argv);
      paramfileset = 1;
      if (DEBUG) 
	printf ("paramfile: %s\n", paramfile);
      argc--;
      break;
      
    case 's':      /* set segsites file */
      segfile = (*++argv);
      segfileset = 1;
      if (DEBUG)
	printf("segfile: %s\n", segfile);
      argc--;
      break;
      
    case 'o':      /* set haplo/marker base file name */
      outfilebase = (*++argv);
      outfileset = 1;
      argc--;
      break;
      
    case 'v':      /* set verbose flag. does nothing yet. */
      verbose = 1;
      if (DEBUG)
	printf("set to verbose\n");
      
      break;
      
    default:
      fprintf(stderr, 
	      "WARNING coalescent: illegal option %c\n", 
	      c);
      argc = 0;
      usage = 1;
      break;				
    }
  }
  if (usage)
    printusage();
  
  else if (! paramfileset) {
    fprintf(stderr, "coalescent: must use -p option\n");
    printusage();
  }
  else {
    if (segfileset) {
      if ((segfp = fopen(segfile, "w")) == NULL) {
	fprintf(stderr, 
		"ERROR %s: cannot open file %s for writing\n",
		prog, 
		segfile);
	exit (EXIT_FAILURE);
      }
    }
    
    else segfp = NULL;
    
    if (logfileset) {
      if ((logfp = fopen(logfile, "w")) == NULL) {
	fprintf(stderr, 
		"ERROR %s: cannot open file %s for writing\n",
		prog, logfile);
	exit(EXIT_FAILURE);
      }
    }
    else logfp = NULL;
    
    dg_set_logfile(logfp);
    
    dg_initialize();
    length = file_read(paramfile, segfp);
    
    mutlist_init(&muts);
    hap_assign_chroms(&haps);
    dg_init_recomb();
        
    sim_execute();
    sim_mutate(segfp, &muts, &haps);

    if (outfileset) {
      print_haps(outfilebase, length, &muts, &haps);
    }
  }
  return 0;
}


void
printusage (void)
{
  fprintf(stderr, "usage: ");
  fprintf(stderr, "coalescent -p param_file ");
  fprintf(stderr, "[-l logfile] [-s segfile]\n");
  
  exit (EXIT_FAILURE);
}
