/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: coalesce.c,v 1.7 2005/09/22 18:32:17 sfs Exp $ */

#include <stdio.h>
#include "defs.h"
#include "segment.h"
#include "node.h"
#include "nodelist.h"
#include "pop.h"
#include "demography.h"
#include "../cosi_rand/random.h"

static double lastrate = 0; 
/* 
 * Calculates the coalesce rate according to the number of
 * nodes in each population. 
 */
double 
coalesce_get_rate (void) 
{
	int numpops = dg_get_num_pops();
	int i;
	double rate = 0;
	int numnodes;
	int popsize;
	
	for (i = 0; i < numpops; i++) {
		numnodes = dg_get_num_nodes_in_pop_by_index (i);
		popsize = dg_get_pop_size_by_index (i);
		if (numnodes > 1)
			rate += (double) (numnodes * (numnodes - 1)) 
				/ (4 * popsize);
	}
	
	lastrate = rate;
	return rate;
}

int
coalesce_pick_popindex () 
{
	double  rate = 0,
		randcounter = random_double() * lastrate;
	int     popindex = 0,
		numpops = dg_get_num_pops(),
		numnodes,
		popsize,
		i;
	
	if (numpops > 1) {
		for (i = 0; i < numpops && randcounter > rate; i++) {
			numnodes = dg_get_num_nodes_in_pop_by_index (i);
			popsize = dg_get_pop_size_by_index (i);
			if (numnodes > 1)
				rate += (double) (numnodes * (numnodes - 1)) 
					/ (4 * popsize);
		}		
		popindex = i - 1;
	}
	return popindex;
}

 
