/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* $Id: bottleneck.c,v 1.6 2005/09/22 18:32:17 sfs Exp $ */
#include <math.h>
#include <stdio.h>
#include "defs.h"
#include "../cosi_rand/poisson.h"
#include "segment.h"
#include "node.h"
#include "nodelist.h"
#include "pop.h"
#include "demography.h"

void 
bottleneck_execute (popid popname, double coeff, int gen) 
{
	int num_nodes = dg_get_num_nodes_in_pop_by_name (popname);
	double t = 0,
		effective_N,
		rate,
		temp;


	if (num_nodes < 2) return;

	effective_N = - 1.0 / ( 2.0 * log (1.0 - coeff));
	rate = (double) (4 * effective_N) / (num_nodes * (num_nodes - 1));
	temp = poisson_get_next (1 / rate);
	t += temp;
	while (t <= 1.0) {
		dg_coalesce_by_name (popname, gen + t);
		num_nodes --;
		if (num_nodes > 1) {
			rate = (double) (4 * effective_N)
				/ (num_nodes * (num_nodes - 1));
			t += poisson_get_next (1/rate);
		}
		else t ++;      /* escape loop */
	}
}

 
